/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import common.ui.Button;
import common.ui.ButtonPanel;
import common.ui.DisplaySizes;
import javax.microedition.lcdui.Graphics;

public final class ScientificButtonPanel
extends ButtonPanel {
    private static final int DOUGLAS_8_WIDTH = 238;
    private static final int DOUGLAS_8_HEIGHT = 120;
    private static final int DOUGLAS_8_X_POS = 2;
    private static final int DOUGLAS_8_Y_POS = 106;
    private static final int DOUGLAS_8_SPACING = 0;
    private static final int DOUGLAS_8_SCROLLBAR_BACKGROUND_WIDTH = 4;
    private static final int DOUGLAS_8_SCROLLBAR_BACKGROUND_HEIGHT = 120;
    private static final int DOUGLAS_8_SCROLLBAR_BACKGROUND_X_POS = 234;
    private static final int DOUGLAS_8_SCROLLBAR_BACKGROUND_Y_POS = 126;
    private static final int DOUGLAS_8_SCROLLBAR_BODY_WIDTH = 4;
    private static final int DOUGLAS_8_SCROLLBAR_BODY_X_POS = 234;
    private static final int DOUGLAS_8_SCROLLBAR_TOP_BOTTOM_EDGE_WIDTH = 4;
    private static final int DOUGLAS_8_SCROLLBAR_TOP_BOTTOM_EDGE_HEIGHT = 2;
    private static final int DOUGLAS_8_SCROLLBAR_TOP_BOTTOM_EDGE_X_POS = 234;
    private static final int S60_3_1_Y_POS = 124;
    private static final int S60_3_1_2_Y_POS = 114;
    private static final int S60_LANDSCAPE_WIDTH = 318;
    private static final int NUMBER_OF_VISIBLE_ROWS = 4;
    private static final int NUMBER_OF_VISIBLE_ROWS_PORTRAIT = 3;
    private int visible_rows;
    private static final int NUMBER_OF_BUTTONS_PER_PAGE = 16;
    private static final int NUMBER_OF_BUTTONS_PER_PAGE_PORTRAIT = 15;
    private int buttons_per_page;
    private static final int S60_SCROLLBAR_BACKGROUND_X_POS = 314;
    private static final int S60_SCROLLBAR_TOP_BOTTOM_EDGE_X_POS = 314;
    private static final int S60_SCROLLBAR_BODY_X_POS = 314;
    private static final int S60_HEIGHT = 90;
    private static final int S60_SCROLLBAR_BACKGROUND_HEIGHT = 90;
    private final int buttonHeight;
    private int yPosScroll = 0;
    private int scrollbarBackgroundWidth = 0;
    private int scrollbarBackgroundHeight = 0;
    private int scrollbarBackgroundXPos = 0;
    private int scrollbarBackgroundYPos = 0;
    private int scrollbarBodyWidth = 0;
    private int scrollbarBodyXPos = 0;
    private int scrollbarTopBottomEdgeWidth = 0;
    private int scrollbarTopBottomEdgeHeight = 0;
    private int scrollbarTopBottomEdgeXPos = 0;
    private int numberOfPages = 0;
    private int currentPageIndex = 0;

    public ScientificButtonPanel(DisplaySizes displaySize) {
        super(displaySize);
        if (displaySize == DisplaySizes.DOUGLAS_8) {
            this.width = 238;
            this.height = 120;
            this.xPos = 2;
            this.yPos = 124;
            this.spacing = 0;
            this.scrollbarBackgroundWidth = 4;
            this.scrollbarBackgroundHeight = 120;
            this.scrollbarBackgroundXPos = 234;
            this.scrollbarBackgroundYPos = 126;
            this.scrollbarBodyWidth = 4;
            this.scrollbarBodyXPos = 234;
            this.scrollbarTopBottomEdgeWidth = 4;
            this.scrollbarTopBottomEdgeHeight = 2;
            this.scrollbarTopBottomEdgeXPos = 234;
        } else if (displaySize == DisplaySizes.S60_3_1) {
            this.width = 238;
            this.height = 120;
            this.xPos = 2;
            this.yPos = 124;
            this.spacing = 0;
            this.scrollbarBackgroundWidth = 4;
            this.scrollbarBackgroundHeight = 120;
            this.scrollbarBackgroundXPos = 234;
            this.scrollbarBackgroundYPos = 126;
            this.scrollbarBodyWidth = 4;
            this.scrollbarBodyXPos = 234;
            this.scrollbarTopBottomEdgeWidth = 4;
            this.scrollbarTopBottomEdgeHeight = 2;
            this.scrollbarTopBottomEdgeXPos = 234;
        } else if (displaySize == DisplaySizes.S60_3_1_OLD) {
            this.width = 238;
            this.height = 120;
            this.xPos = 2;
            this.yPos = 114;
            this.spacing = 0;
            this.scrollbarBackgroundWidth = 4;
            this.scrollbarBackgroundHeight = 120;
            this.scrollbarBackgroundXPos = 234;
            this.scrollbarBackgroundYPos = 126;
            this.scrollbarBodyWidth = 4;
            this.scrollbarBodyXPos = 234;
            this.scrollbarTopBottomEdgeWidth = 4;
            this.scrollbarTopBottomEdgeHeight = 2;
            this.scrollbarTopBottomEdgeXPos = 234;
        } else if (displaySize == DisplaySizes.S60_3_2_SDK) {
            this.width = 238;
            this.height = 120;
            this.xPos = 2;
            this.yPos = 124;
            this.spacing = 0;
            this.scrollbarBackgroundWidth = 4;
            this.scrollbarBackgroundHeight = 120;
            this.scrollbarBackgroundXPos = 234;
            this.scrollbarBackgroundYPos = 126;
            this.scrollbarBodyWidth = 4;
            this.scrollbarBodyXPos = 234;
            this.scrollbarTopBottomEdgeWidth = 4;
            this.scrollbarTopBottomEdgeHeight = 2;
            this.scrollbarTopBottomEdgeXPos = 234;
        } else if (displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.width = 318;
            this.height = 90;
            this.xPos = 2;
            this.yPos = 106;
            this.spacing = 0;
            this.scrollbarBackgroundWidth = 4;
            this.scrollbarBackgroundHeight = 90;
            this.scrollbarBackgroundXPos = 314;
            this.scrollbarBackgroundYPos = 126;
            this.scrollbarBodyWidth = 4;
            this.scrollbarBodyXPos = 314;
            this.scrollbarTopBottomEdgeWidth = 4;
            this.scrollbarTopBottomEdgeHeight = 2;
            this.scrollbarTopBottomEdgeXPos = 314;
        }
        if (displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.addButton(0);
            this.addButton(1);
            this.addButton(2);
            this.addButton(3);
            this.addButton(20);
            this.addButton(21);
            this.addButton(24);
            this.addButton(4);
            this.addButton(8);
            this.addButton(5);
            this.addButton(25);
            this.addButton(27);
            this.addButton(28);
            this.addButton(6);
            this.addButton(7);
            this.addButton(26);
            this.addButton(22);
            this.addButton(23);
            this.addButton(16);
            this.addButton(19);
            this.addButton(9);
            this.addButton(10);
            this.addButton(11);
            this.addButton(4);
            this.addButton(12);
            this.addButton(13);
            this.addButton(14);
            this.addButton(18);
            this.addButton(17);
            this.addButton(15);
        } else {
            this.addButton(0);
            this.addButton(1);
            this.addButton(2);
            this.addButton(3);
            this.addButton(20);
            this.addButton(21);
            this.addButton(24);
            this.addButton(4);
            this.addButton(8);
            this.addButton(5);
            this.addButton(25);
            this.addButton(27);
            this.addButton(6);
            this.addButton(7);
            this.addButton(26);
            this.addButton(28);
            this.addButton(22);
            this.addButton(23);
            this.addButton(16);
            this.addButton(19);
            this.addButton(9);
            this.addButton(10);
            this.addButton(11);
            this.addButton(4);
            this.addButton(12);
            this.addButton(13);
            this.addButton(14);
            this.addButton(27);
            this.addButton(18);
            this.addButton(17);
            this.addButton(15);
            this.addButton(28);
        }
        this.buttonHeight = ((Button)this.buttons.firstElement()).getHeight();
        this.init();
    }

    private void init() {
        if (this.width == 238) {
            this.buttons_per_page = 16;
            this.visible_rows = 4;
        } else if (this.width == 318) {
            this.buttons_per_page = 15;
            this.visible_rows = 3;
        }
        this.numberOfPages = this.buttons.size() / this.buttons_per_page;
        if (this.buttons.size() % this.buttons_per_page != 0) {
            ++this.numberOfPages;
        }
    }

    public void paint(Graphics g) {
        this.init();
        super.paint(g);
        int firstVisibleButtonIndex = this.currentPageIndex * this.buttons_per_page;
        int lastVisibleButtonIndex = (this.currentPageIndex + 1) * this.buttons_per_page - 1;
        g.translate(0, this.yPosScroll);
        for (int i = firstVisibleButtonIndex; i <= lastVisibleButtonIndex; ++i) {
            Button button = (Button)this.buttons.elementAt(i);
            button.paint(g);
        }
        g.translate(0, -this.yPosScroll);
        this.drawScrollBar(g);
    }

    public void keyPressed(int keyCode, int gameAction) {
        super.keyPressed(keyCode, gameAction);
        if (keyCode == 42 || keyCode == 117) {
            this.moveToNextPage(true);
        }
    }

    protected void highlightButtonAbove() {
        super.highlightButtonAbove();
        if (this.currentRowIndex % this.visible_rows == 0) {
            this.moveToPreviousPage();
        }
    }

    protected void highlightRightButton() {
        super.highlightRightButton();
        if (this.currentRowIndex % this.visible_rows == this.visible_rows - 1 && this.currentColumnIndex == this.columns - 1) {
            this.moveToNextPage(false);
        }
    }

    protected void highlightButtonBelow() {
        super.highlightButtonBelow();
        if (this.currentRowIndex % this.visible_rows == this.visible_rows - 1) {
            this.moveToNextPage(false);
        }
    }

    protected void highlightLeftButton() {
        super.highlightLeftButton();
        if (this.currentRowIndex % this.visible_rows == 0 && this.currentColumnIndex == 0) {
            this.moveToPreviousPage();
        }
    }

    private void moveToNextPage(boolean hashKey) {
        if (this.currentPageIndex < this.numberOfPages - 1) {
            ++this.currentPageIndex;
            this.yPosScroll -= this.visible_rows * this.buttonHeight + this.visible_rows * this.spacing;
            if (hashKey) {
                this.highlightedButton.setHighlighted(false);
                this.highlightedButtonIndex += this.buttons_per_page;
                this.highlightedButton = (Button)this.buttons.elementAt(this.highlightedButtonIndex);
                this.highlightedButton.setHighlighted(true);
            }
        } else if (this.currentPageIndex == this.numberOfPages - 1) {
            this.currentPageIndex = 0;
            this.yPosScroll = 0;
            if (hashKey) {
                this.highlightedButton.setHighlighted(false);
                this.highlightedButtonIndex = (this.highlightedButtonIndex + this.buttons_per_page) % this.buttons_per_page;
                this.highlightedButton = (Button)this.buttons.elementAt(this.highlightedButtonIndex);
                this.highlightedButton.setHighlighted(true);
            }
        }
    }

    private void moveToPreviousPage() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
            this.yPosScroll += this.visible_rows * this.buttonHeight + this.visible_rows * this.spacing;
        } else if (this.currentPageIndex == 0) {
            this.currentPageIndex = this.numberOfPages - 1;
            this.yPosScroll = -this.currentPageIndex * (this.visible_rows * this.buttonHeight + this.visible_rows * this.spacing);
        }
    }

    private void drawScrollBar(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(this.scrollbarBackgroundXPos, this.scrollbarBackgroundYPos, this.scrollbarBackgroundWidth, this.scrollbarBackgroundHeight);
        int heightOfAllRows = this.numberOfRows * this.buttonHeight + (this.numberOfRows - 1) * this.spacing;
        int scrollbarHeight = this.scrollbarBackgroundHeight / (1 + heightOfAllRows / this.scrollbarBackgroundHeight) + 2 * this.scrollbarTopBottomEdgeHeight;
        int scrollbarYPos = (this.scrollbarBackgroundHeight - scrollbarHeight) * -this.yPosScroll / (heightOfAllRows - this.scrollbarBackgroundHeight);
        g.setColor(0);
        g.fillRect(this.scrollbarTopBottomEdgeXPos, this.scrollbarBackgroundYPos + scrollbarYPos, this.scrollbarTopBottomEdgeWidth, this.scrollbarTopBottomEdgeHeight);
        g.fillRect(this.scrollbarBodyXPos, this.scrollbarBackgroundYPos + scrollbarYPos + this.scrollbarTopBottomEdgeHeight, this.scrollbarBodyWidth, scrollbarHeight - 2 * this.scrollbarTopBottomEdgeHeight);
        g.fillRect(this.scrollbarTopBottomEdgeXPos, this.scrollbarBackgroundYPos + scrollbarYPos + scrollbarHeight - this.scrollbarTopBottomEdgeHeight, this.scrollbarTopBottomEdgeWidth, this.scrollbarTopBottomEdgeHeight);
    }
}

